#include <stdio.h>
#include "CryptoEngine2.h"

#include "CE2_TST_ECC.h"
#include "CE2_TST_AES.h"
#include "CE2_TST_ECC_2.h"
#include "CE2_TST_HASH.h"
#include "CE2_TST_HMAC.h"
#include "CE2_TST_DH.h"
#include "CE2_TST_DH_KG.h"
#include "CE2_TST_RC4.h"
#include "CE2_TST_RSA.h"
#include "CE2_TST_C2.h"
#include "CE2_TST_OTF.h"
#include "CE2_TST_RSA_2.h"
#include "CE2_TST_CMLA.h"
#include "CE2_TST_KDF.h"
#include "CE2_TST_RND.h"
#include "CE2_TST_Utils.h"
#include "CE2_TST_Base64.h"

#ifdef LOG_TO_FILE
const char* log_file_name = "test_log.txt";
#endif

int main(int argc, char* argv[])
{
	FILE *out_log_file;
	DxStatus result = CE2_TST_VALID;
	int error_code = 0;

#ifdef LOG_TO_FILE
	error_code = fopen_s(&out_log_file, log_file_name, "w");
	if (error_code != 0) {
		printf("Can't create log file '%s'!\n", log_file_name);
		return 1;
	}
#else
	out_log_file = stdout;
#endif

	fprintf(out_log_file, "Tests begin:\n");
	if (out_log_file != stdout)
		printf("Tests begin:\n\n");

#if 1
	result |= CE2_TST_Base64(out_log_file); 
	result |= CE2_TST_Base64_Acceptance(out_log_file); 
	result |= CE2_TST_ECC_KeyExportImport(out_log_file);
	result |= CE2_TST_ECC_DH(out_log_file);
	result |= CE2_TST_ECC_ElGamal_EncDec(out_log_file);
	result |= CE2_TST_ECC_ECDSA(out_log_file);
	result |= CE2_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify(out_log_file, 0);
	result |= CE2_ATP_TST_ECC_Acceptance_DH(out_log_file, 0);
	result |= CE2_ATP_TST_ECC_Acceptance_ElGamal_EncDec(out_log_file, 0); 
	result |= CE2_ATP_TST_ECC_Acceptance_ImportExportKeyPair(out_log_file, 0); 
	result |= CE2_TST_ECC_ECDSA_ZeroMessage(out_log_file);
	result |= BugCheck_2007_03_28(out_log_file);
	result |= BugCheck_2007_04_10(out_log_file);
	result |= BugCheck_2007_04_26(out_log_file);

	result |= CE2_TST_HMAC(out_log_file);
	result |= CE2_TST_HASH(out_log_file);
	result |= CE2_TST_HASH_Sequence(out_log_file);

	result |= CE2_ATP_TST_DH_Acceptance_ANSI942(out_log_file);
	result |= CE2_ATP_TST_DH_Acceptance_PKCS3(out_log_file);

	result |= CE2_ATP_TST_DH_CreateDomainParams_Acceptance(out_log_file);
	result |= CE2_ATP_TST_DH_CreateDomainParams(out_log_file);
	result |= CE2_ATP_TST_DH_CheckDomainParams_Acceptance(out_log_file);
	result |= CE2_ATP_TST_DH_CheckPubKey_Acceptance(out_log_file);

	result |= CE2_ATP_TST_RC4_Acceptance_Integrated(out_log_file);

	result |= CE2_ATP_TST_RSA_Acceptance_PRIME_EncDec(out_log_file);
	result |= CE2_ATP_TST_RSA_Acceptance_PRIME_SignVerify(out_log_file);
	result |= CE2_ATP_TST_RSA_Acceptance_PKCS1v15_EncDec(0, out_log_file);
	result |= CE2_ATP_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify(0, out_log_file);
	result |= CE2_ATP_TST_RSA_Acceptance_OAEP_EncDec(0, out_log_file);
	result |= CE2_TST_RSA_Build_Get_PubKey(out_log_file);
	result |= CE2_TST_RSA_Build_Get_PrivKey(0, out_log_file);
	result |= CE2_TST_RSA_PRIME_Encrypt_Decrypt_PKCS1v15v21(out_log_file);
	result |= CE2_TST_RSA_PRIME_Encrypt_Decrypt_PKCS1v15v21_ZeroMessage(out_log_file);
 	result |= CE2_TST_RSA_SHEME_EncDec_01(out_log_file);
	result |= CE2_TST_RSA_PRIME_EncDecTest(out_log_file);
	result |= CE2_TST_RSA_PRIME_EncDecTest2(out_log_file);
	result |= CE2_TST_RSA_SHEME_SignVerify_ZeroMessage_01(out_log_file);

// 	result |= CE2_TST_RSA_UTILS_EASY_TST(out_log_file);

	result |= CE2_TST_C2_ECB(out_log_file);
	result |= CE2_TST_C2_C_CBC(out_log_file);
	result |= CE2_TST_C2_HASH(out_log_file);
	result |= CE2_TST_C2_OneWayFunc(out_log_file);

	result |= CE2_TST_OTF_AES2AES2HASH(out_log_file);
	result |= CE2_TST_OTF_AES2DES2HASH(out_log_file);
	result |= CE2_TST_OTF_DES2AES2HASH(out_log_file);

	result |= CE2_TST_CMLA_Wrap_Unwrap(out_log_file);
	result |= CE2_TST_CMLA_RSA_Encrypt_Decrypt(out_log_file);
	result |= CE2_TST_CMLA_B1(out_log_file);

	//result |= CE2_TST_KDF_Concat(out_log_file);//?
	result |= CE2_TST_KDF_ASN1(out_log_file);

	result |= CE2_TST_Utils_MulNum(out_log_file);
	result |= CE2_TST_Utils_GetBufferEffectiveSizeInBits(out_log_file);

	result |= CE2_ATP_TST_AES_Acceptance_Integrated(out_log_file); 
	result |= CE2_ATP_TST_AES_Acceptance_KeyWrapUnwarp(out_log_file); 
	result |= CE2_ATP_TST_AES_Acceptance_MAC_integrated(out_log_file); 
	result |= CE2_TST_AES_XCBC_MAC(out_log_file);
	result |= CE2_TST_AES_CMAC(out_log_file);
	result |= CE2_TST_XTS_AES_EncryptDecrypt(out_log_file);
	result |= CE2_TST_XTS_AES_EncryptDecrypt_TweakInternal(out_log_file);
	result |= CE2_TST_XTS_AES_CRYS_COMPARE(out_log_file);
	result |= CE2_TST_AES_CCM_01(out_log_file);
	result |= CE2_TST_AES_GCM_01(out_log_file);
#endif



	if (result == CE2_TST_VALID) {
		fprintf(out_log_file, "\nTests are valid.\n");
		if (out_log_file != stdout)
			printf("\nTests are valid. \n\n");
	} else {
		fprintf(out_log_file, "\nTests are failed.\n");
#ifdef LOG_TO_FILE
		if (out_log_file != stdout)
			printf("\nTests are failed. See '%s' log-file.\n\n", log_file_name);
#endif
	}

#ifdef LOG_TO_FILE
	fclose(out_log_file);
#endif

	return 0;
}

